#include "Command.h"
#include "Gear.h"
#include "Direction.h"
#include "Pause.h"
#include "ObjectFileHandler.h"
#include <memory>
#include <string>
#include <vector>
#include <iostream>

int main()
{
    ObjectFileHandler f("../test.txt");
    std::cout << "Writing: " << f.getFileName() << '\n';
    std::vector<std::shared_ptr<ICommand>> v;
    v.emplace_back(std::make_shared<Gear>(1,2));
    v.emplace_back(std::make_shared<Direction>(3));
    v.emplace_back(std::make_shared<Pause>(4));
    std::cout << "Success: " << f.write(v) << std::endl;

    std::vector<std::shared_ptr<ICommand>> vR;
    f.read(vR);
    std::cout << "Now reading\n";
    for (auto &&i : vR)
    {
        auto command = std::dynamic_pointer_cast<Command>(i);
        if (command)
            std::cout << command->getConfig() << std::endl;
    }

    return 0;
}