#include <iostream>

#include "Gear.h"
#include "Direction.h"
#include "Pause.h"
#include "IControlModelListener.h"
#include "ControlModel.h"

class Listener : public IControlModelListener
{
    void messageUpdated(std::string _message)
    {
        std::cout << "Got Message: " << _message << '\n';
    }
    void roverUpdated()
    {
        std::cout << "Rover was updated\n";
    }
};

int main()
{
    ControlModel &model = ControlModel::getInstance();
    Listener listener = Listener();
    model.addControlModelListener(&listener);

    model.getCommandList().add(model.getCommandTypes()[0].createInstance());
    model.getCommandList().add(model.getCommandTypes()[1].createInstance());
    model.getCommandList().add(model.getCommandTypes()[2].createInstance());

    model.getCommandList().add(Gear(1, 1.0));
    model.getCommandList().add(Direction(30));
    model.getCommandList().add(Pause(0.5));

    model.readCommands("../testCommands.txt");

    model.start();

    model.setSelectedRover();

    std::cout << "Save To File?" << std::endl;
    int yeanah = 0;
    std::cin >> yeanah;
    if (yeanah)
    {
        model.writeCommands("../testCommands.txt");
        std::cout << "Wrote to ../testCommands.txt" << std::endl;
    }
}