#include <iostream>

using std::cout;
using std::string;

class ControlDeveloper
{
private:
    // class variable
    // explicit "inline" to initialize in this translatin unit
    inline static string CD_Class = "CLASS Control-Developer";
    // member variable
    const string CD_Member = "MEMBER Control-Developer";
public:
    // declare static to be called without object
    static string getCDClass() { return CD_Class; }
    // regular getter
    string getCDMember() { return CD_Member; }
};


int main()
{
    cout << "Demonstration of class vs. member variables:\n";
    cout << "Without constructing an object we can call the static getter from the CD namespace:\n";
    cout << "CD_Class:  " << ControlDeveloper::getCDClass() << '\n';
    cout << "To be able to get the member variable we need to construct";
    cout << " an object as the value will be specifically created for every object.\n";
    ControlDeveloper cd = ControlDeveloper();
    cout << "We can now call the non static getter:\n";
    cout << "CD_Member: " << cd.getCDMember() << '\n';
    cout << "We can now also use the object to call the static getter (with the same effect):\n";
    cout << "CD_Class:  " << cd.getCDClass() << '\n';
    return 0;
}