#pragma once
#include <QAbstractTableModel>
#include <array>
#include "CommandListOWN.h"

/**
 * @brief The Model representing the data displayed in the
 *  QTableView of PanelCommandTabel.
 * 
 */
class TableCommandModel : public QAbstractTableModel
{
private:
    std::array<QString, 3> headerNames = {"No.", "Command", "Configuration"};
    CommandList *cL;
    int rowsBefore = 0;

public:
    /**
     * @brief Construct a new Table Command Model object
     *  Remember the CommandList pointer.
     * @param _list 
     */
    TableCommandModel(CommandList *_list) { cL = _list; }
    QVariant data(const QModelIndex &index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;

    /**
     * @brief return the fixed width of the Table (3 columns).
     * 
     * @param parent default QModelIndex() means invalid
     * @return int, width of the Table (3 columns).
     */
    int columnCount(const QModelIndex &parent = QModelIndex()) const { return 3; }

    /**
     * @brief return the variable amount of rows in the table.
     *  The number of elements is fetched from the CommandList.
     * @param parent default QModelIndex() means invalid
     * @return int, amount of elements in the list.
     */
    int rowCount(const QModelIndex &parent = QModelIndex()) const { return cL->getSize(); }

    QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) { return createIndex(row, column, nullptr); }
    QModelIndex parent(const QModelIndex &index) { return QModelIndex(); }

    void onChange(std::shared_ptr<ICommand> _icom);
};
