#pragma once
#include <QLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include "ControlModel.h"

/**
 * @brief A Dialog to select and acknowledge a Rover.
 *  The Rover is not acively selected.
 */
class RoverDialog : public QDialog
{

private:
    QLineEdit *tRover;
    QPushButton *bOk;

public:
    /**
     * @brief Construct a new Rover Dialog object
     *  Will tell the Model to select a Rover,
     *  then display the RoverID in a LineEdit.
     *  The Ok button is connected to accept() closing the window on click.
     * 
     * @param cM Pointer to the ControlModel
     */
    RoverDialog(ControlModel * cM)
    {
        cM->setSelectedRover();
        std::string id = cM->getSelectedRoverId().value_or("none");
        setWindowTitle("Rover Selection");
        QVBoxLayout *l = new QVBoxLayout();
        this->setLayout(l);
        l->addWidget(new QLabel("The following Rover was selected:"));
        tRover = new QLineEdit(id.c_str());
        tRover->setAlignment(Qt::AlignCenter);
        tRover->setReadOnly(true);
        l->addWidget(tRover);
        bOk = new QPushButton("Ok");
        l->addWidget(bOk);
        updateGeometry();
        connect(bOk, SIGNAL(clicked()), this, SLOT(accept()));
    };
};