#pragma once
#include "commandlib.h"
#include "Command.h"
#include <string>

/**
 * @brief The Pause command makes the robot do nothing
 * for the set time.
 */
class Pause : public Command, public IPause
{
private:
    double duration;
public:
    Pause();
    Pause(double newDuration);
    void setDuration(double newDuration);
    double getDuration() { return duration; }
    std::string getConfig();
};
