#include "Pause.h"

/**
 * @brief Construct a new Pause:: Pause Command setting its duration variable
 * 
 * @param newDuration 
 */
Pause::Pause(double newDuration) : Command(IPause::pause)
{
    setDuration(newDuration);
}

/**
 * @brief Change the duration variable
 * 
 * @param newDuration 
 */
void Pause::setDuration(double newDuration)
{
    if (newDuration < 0)
        duration = 0;
    else
        duration = newDuration;
}

/**
 * @brief Returns a string representation of the Command
 * and it's value.
 * @return std::string "Pause - Duration: ...s"
 */
std::string Pause::getConfig()
{
    std::string str = IPause::pause
                    + " - Duration: "
                    + std::to_string(duration)
                    + 's';
    return str;
};