#pragma once
#include <QLineEdit>
#include <QPushButton>
#include "PanelCommandConfig.h"
#include "ControlUI.h"

/**
 * @brief The ConfigPanel specific to a Gear Command.
 * 
 */
class PanelConfigGear : public PanelCommandConfig
{

Q_OBJECT

private:
    ControlUI *cui;
    void setView();
    void setController();
    QPushButton *bSave;
    QLineEdit *tSpeed;
    QLineEdit *tDuration;

public:
    PanelConfigGear(ControlUI *_cui);
    void update(std::shared_ptr<ICommand>);

private slots:
    void onSaveButton();
};