#pragma once
#include <QListWidget>
#include <QPushButton>
#include "ControlModel.h"

/**
 * @brief A Panel to select one of the possible CommandTypes
 *  and add them to the CommandList.
 */
class PanelCommandTypes : public QWidget
{

Q_OBJECT

private:
    QListWidget *commandTypeList;
    QPushButton *bAdd;
    ControlModel *cM;

    void setView();
    void setController();

signals:
    void pleaseUpdateTable(std::shared_ptr<ICommand>);

private slots:
    void onAddButton();

public:
    PanelCommandTypes(ControlModel *_cM);
};
