#include <QBoxLayout>

#include "PanelCommandTypes.h"
#include "ComTypeListWidgetItem.h"

/**
 * @brief Construct a new Panel Command Types:: Panel Command Types object.
 *  set View and Controller.
 * @param _cM Pointer to the ControlModel.
 */
PanelCommandTypes::PanelCommandTypes(ControlModel *_cM)
{
    cM = _cM;
    setView();
    setController();
}

/**
 * @brief Set up and configure all the Widgets
 * 
 */
void PanelCommandTypes::setView()
{
    QBoxLayout *layout = new QBoxLayout(QBoxLayout::Direction::TopToBottom);
    setLayout(layout);
    commandTypeList = new QListWidget();
    layout->addWidget(commandTypeList);
    bAdd = new QPushButton("Add");
    layout->addWidget(bAdd);

    for (auto &&i : cM->getCommandTypes())
    {
        commandTypeList->addItem(new ComTypeListWidgetItem(&i));
    }
}

/**
 * @brief Connect the Button to the onAddButton callback function.
 * 
 */
void PanelCommandTypes::setController()
{
    connect(bAdd, SIGNAL(clicked()), this, SLOT(onAddButton()));
}

/**
 * @brief Add an ICommand of the selected Type to the CommandList.
 *  The selected QListWidgetItem is cast to ComTypeListWidgetItem
 *  to be able to extract the CommandType.
 *  Emits pleaseUpdateTable() for the new ICommand.
 */
void PanelCommandTypes::onAddButton()
{
    ComTypeListWidgetItem *listItem = dynamic_cast<ComTypeListWidgetItem*>(commandTypeList->currentItem());
    if (listItem)
    {
        std::shared_ptr<ICommand> newCommand = listItem->getCommandType()->createInstance();
        cM->getCommandList().add(newCommand);
        emit(pleaseUpdateTable(newCommand));
    }
}