#pragma once
#include <QListWidget>
#include <QLabel>
#include <QPushButton>
#include <QTableView>
#include <memory>
#include <commandlib.h>
#include "ControlModel.h"
#include "TableCommandModel.h"

/**
 * @brief The middle Panel displaying many Buttons to modify the list,
 *  to start and stop the execution, info about the rover
 *  and of course the list itself in form of a table.
 * 
 *  Because of include loops the ControlUI can not be known by this Panel.
 *  That is why the signals where introduced as an anonymous way to communicate any changes.
 *  pleaseUpdateTable() is kind of useless as the table model is managed by this class anyway.
 */
class PanelCommandTable : public QWidget
{

Q_OBJECT

private:
    TableCommandModel *tM;
    QPushButton *bRemove;
    QPushButton *bUp;
    QPushButton *bDown;
    QLabel *lRover;
    QPushButton *bStart;
    QPushButton *bStop;
    QTableView *tCommands;
    QItemSelectionModel *lSM;

    ControlModel *cM;

    void setView();
    void setController();


public:
    PanelCommandTable(ControlModel *_cM);
    void updateTable(std::shared_ptr<ICommand> _icom);
    void updateSelectedRover();

signals:
    void pleaseUpdateTable(std::shared_ptr<ICommand>);
    void pleaseUpdateConfig(std::shared_ptr<ICommand>);

public slots:
    void onRemoveButton();
    void onUpButton();
    void onDownButton();
    void onStartButton();
    void onStopButton();
    void onSelectionChange(const QModelIndex &current, const QModelIndex &previous);
};
