#pragma once
#include <QWidget>
#include <memory>
#include "commandlib.h"

/**
 * @brief An abstract base class to be able to switch
 *  between more specific panels for each Command type.
 */
class PanelCommandConfig : public QWidget
{

protected:
    std::shared_ptr<ICommand> command;

public:
    /**
     * @brief Should update the parameters displayed in the
     *  LineEdits according to the selected Command.
     */
    virtual void update(std::shared_ptr<ICommand>) = 0;
};
