#pragma once
#include "commandlib.h"
#include "Command.h"
#include <string>

/**
 * @brief The Gear command makes the robot drive in a straight line
 * with the set speed for the set time.
 */
class Gear : public Command, public IGear
{
private:
    int speed;
    double duration;

public:
    Gear();
    Gear(int newSpeed, double newDuration);
    void setSpeed(int newSpeed);
    int getSpeed() { return speed; }
    void setDuration(double newDuration);
    double getDuration() { return duration; }
    std::string getConfig();
};
