#include "Gear.h"

/**
 * @brief Construct a new Gear:: Gear Command setting its variables.
 * 
 * @param newSpeed is the speed to be set
 * @param newDuration the time for which to drive 
 */
Gear::Gear(int newSpeed, double newDuration) : Command(IGear::gear)
{
    setSpeed(newSpeed);
    setDuration(newDuration);
}

/**
 * @brief Change the speed variable,
 * clipping at -100 and +100.
 * @param newSpeed the speed to be set
 */
void Gear::setSpeed(int newSpeed)
{
    if (newSpeed <= -100)
        speed = -100;
    else if (newSpeed >= 100)
        speed = 100;
    else
        speed = newSpeed;
}

/**
 * @brief Change the duration variable.
 * 
 * @param newDuration the duration to be set
 */
void Gear::setDuration(double newDuration)
{
    if (newDuration < 0)
        duration = 0;
    else
        duration = newDuration;
}

/**
 * @brief Returns a string representation of the Command
 * and it's values.
 * @return std::string "Gear - Speed: ... for: ...s"
 */
std::string Gear::getConfig()
{
    std::string str = IGear::gear
                    + " - Speed: "
                    + std::to_string(speed)
                    + " for: "
                    + std::to_string(duration)
                    + 's';
    return str;
}