#pragma once
#include <memory>

#include "Command.h"

/**
 * @brief Element of the doubly linked list CommandList.
 * 
 */
class Element
{
private:
    std::shared_ptr<Element> next;
    std::shared_ptr<Element> prev;
    std::shared_ptr<ICommand> cmd;

public:
    /**
     * @brief Construct a new Element object with a std::shared_ptr of type Type.
     * The template function does not check if Type inherits from Command, potential bug.
     * @tparam Type typename of _cmd is implicitly given.
     * @param _cmd the Command to be held by this Element.
     */
    template <typename Type>
    Element(Type _cmd) { cmd = std::make_shared<Type>(_cmd); }

    /**
     * @brief Construct a new Element object with a std::shared_ptr of ICommand.
     * @param _cmd the ICommand to be held by this Element.
     */
    Element(std::shared_ptr<ICommand> _cmd) { cmd = _cmd; }

    /**
     * @brief Construct an empty Element object. Dont use this constructor!
     * 
     * @warning This is constructor is only needed when initializing the root Element of the CommandList!
     */
    Element() {}

    /**
     * @brief Get the ICommand pointer
     * 
     * @return std::shared_ptr<ICommand> 
     */
    std::shared_ptr<ICommand> getCommand() { return cmd; }
    
    /**
     * @brief Set the next Element
     * 
     * @param _next to the next Element
     */
    void setNext(std::shared_ptr<Element> _next) { next = _next; }

    /**
     * @brief Get the next Element
     * 
     * @return std::shared_ptr<Element> of the next Element
     */
    std::shared_ptr<Element> getNext() { return next; }

    /**
     * @brief Set the previous Element
     * 
     * @param _prev of the previous Element
     */
    void setPrev(std::shared_ptr<Element> _prev) { prev = _prev; }

    /**
     * @brief Get the previous Element
     * 
     * @return std::shared_ptr<Element> of the previous Element
     */
    std::shared_ptr<Element> getPrev() { return prev; }
};