#pragma once
#include "commandlib.h"
#include "Command.h"
#include <string>

/**
 * @brief The Direction command makes the robot turn around the set angle in place.
 * 
 */
class Direction : public Command, public IDirection
{
private:
    int degree;
public:
    Direction();
    Direction(int newDegree);
    void setDegree(int newDegree);
    int getDegree() { return degree; }
    std::string getConfig();
};
