#include "Direction.h"

/**
 * @brief Construct a new Direction:: Direction Command setting its
 * degree variable.
 * @param newDegree, the angle to be set
 */
Direction::Direction(int newDegree) : Command(IDirection::direction)
{
    setDegree(newDegree);
}

/**
 * @brief Change the angle variable,
 * clipping at -90 and +90 degrees.
 * @param newDegree, the angle to be set
 */
void Direction::setDegree(int newDegree)
{
    if (newDegree <= -90)
        degree = -90;
    else if (newDegree >= 90)
        degree = 90;
    else
        degree = newDegree;
}

/**
 * @brief Returns a string representation of the Command
 * and it's value.
 * @return std::string "Direction - Degree: ...."
 */
std::string Direction::getConfig()
{
    std::string str = IDirection::direction
                    + " - Degree: "
                    + std::to_string(degree)
                    + '.';
    return str;
};