#pragma once

#include <QMainWindow>
#include <QTableView>
#include <QStackedWidget>
#include <QTextEdit>
#include <QMenuBar>
#include <QMenu>
#include <QAction>

#include <array>
#include "commandlib.h"
#include "IControlModelListener.h"
#include "PanelCommandConfig.h"
#include "PanelCommandTable.h"
#include "PanelCommandTypes.h"

/**
 * @brief Central Element of the GUI.
 * 
 */
class ControlUI : public QMainWindow, IControlModelListener
{
    Q_OBJECT

private:
    QTextEdit *messageArea;
    QStackedWidget *configStack;
    PanelCommandTypes *panelTypes;
    PanelCommandTable *panelTable;
    std::array<PanelCommandConfig *, 4> panelConfigs;
    enum confNum
    {
        cDefault = 0,
        cDirection = 1,
        cGear = 2,
        cPause = 3
    };
    QMenuBar *menuBar;
    QMenu *mFile;
    QAction *aOpen;
    QAction *aSave;
    QAction *aRover;
    QAction *aExit;
    QMenu *mHelp;
    QAction *aAbout;
    void setView();
    void setController();
    void addMenuBar();

public:
    ControlUI(QWidget *parent = nullptr);
    ~ControlUI();


    void messageUpdated(std::string _message);
    void roverUpdated();

public slots:
    void updateTableView(std::shared_ptr<ICommand> _icom);
    void updateConfigView(std::shared_ptr<ICommand> _icom);
private slots:
    void onOpen();
    void onSave();
    void onRover();
    void onExit();
    void onAbout();
};
