#pragma once
#include "IControlModelListener.h"
#include <string>
#include <memory>
#include <vector>

/**
 * @brief ControlModelRegistry allows another class to use the Observer pattern.
 * It registers Objects by raw pointer, not taking any ownership nor checking their validity.
 */
class ControlModelRegistry
{
private:
    std::vector<IControlModelListener *> registry;

public:
    void addControlModelListener(IControlModelListener *_listener);
    void removeControlModelListener(IControlModelListener *_listener);
    void notifyMessageChanged(std::string _message);
    void notifyRoverChanged();
};
