#include "ControlModelRegistry.h"

/**
 * @brief Add a Listener / Subscriber / Observer to the registry.
 * 
 * @param _listener A pointer to listener to be added.
 */
void ControlModelRegistry::addControlModelListener(IControlModelListener *_listener)
{
    registry.push_back(_listener);
}

/**
 * @brief Remove a Listener / Subscriber / Observer from the registry.
 *  Removal happens if the same address is referenced.
 * @param _listener A pointer to listener to be removed.
 */
void ControlModelRegistry::removeControlModelListener(IControlModelListener *_listener)
{
    //see https://en.cppreference.com/w/cpp/container/vector/erase2
    std::erase(registry, _listener);
}

/**
 * @brief Calls messageUpdated() of every object in the registry.
 * 
 * @param _message The message to be communicated to the Listeners.
 */
void ControlModelRegistry::notifyMessageChanged(std::string _message)
{
    for (auto &&i : registry)
    {
        i->messageUpdated(_message);
    }
}

/**
 * @brief Call roverUpdated() of every object in the registry,
 *  not communicating any additional data.
 */
void ControlModelRegistry::notifyRoverChanged()
{
    for (auto &&i : registry)
    {
        i->roverUpdated();
    }
}