#pragma once
#include <iostream>
#include <array>
#include "commandlib.h"
#include "IComListener.h"
#include "ControlModelRegistry.h"
#include "CommandType.h"
#include "CommandListOWN.h"
#include "Rover.h"
#include "RoverHandler.h"
#include "ComHandler.h"
#include "ComState.h"
#include "ObjectFileHandler.h"

/**
 * @brief "Central administration" of the whole ControlDeveloper.
 *  ControlModel is the mediator between the backend and the GUI.
 *  ControlModel is a Singleton.
 */
class ControlModel : public ControlModelRegistry, IComListener
{
private:
    ControlModel();
    ~ControlModel();
    std::array<CommandType, 3> cT = {
        CommandType(IDirection::direction),
        CommandType(IGear::gear),
        CommandType(IPause::pause)};
    CommandList list;
    std::optional<Rover> selectedRover;

public:
    static ControlModel& getInstance();
    void commandPerformed(std::optional<std::shared_ptr<ICommand>> _command, ComState _state);
    bool start();
    bool stop();

    void readCommands(std::string _fileName);
    void writeCommands(std::string _fileName);

    // Possible Lifetime concerns
    CommandList &getCommandList() { return list; }
    // Possible Lifetime concerns
    std::array<CommandType, 3> &getCommandTypes() { return cT; }

    void setSelectedRover();

    std::optional<std::string> getSelectedRoverId();
};
