#pragma once
#include "Command.h"
#include "Gear.h"
#include "Direction.h"
#include "Pause.h"
#include <memory>
#include <string>

/**
 * @brief A class used between the GUI and the ControlModel.
 *  Will display the command given during construction
 *  and instanciate new Objects of that type.
 */
class CommandType 
{
private:
    std::string name;

public:
    CommandType(std::string _name);

    std::string getName() { return name; }
    std::string toString() { return getName(); }
    std::shared_ptr<ICommand> createInstance();
};
