#include "CommandType.h"

/**
 * @brief Construct a new CommandType:: Command Type object
 *  
 * @param _name of the Command to be instanciated later.
 */
CommandType::CommandType(std::string _name)
{
    name = _name;
}

/**
 * @brief Creates an instance of its Command wrapped in a shared_ptr.
 * 
 * @return std::shared_ptr<ICommand> to the new Object.
 */
std::shared_ptr<ICommand> CommandType::createInstance()
{
    if (name == IGear::gear)
        return std::make_shared<Gear>(0, 0);
    else if (name == IDirection::direction)
        return std::make_shared<Direction>(0);
    else if (name == IPause::pause)
        return std::make_shared<Pause>(0);
    else
        return nullptr;
}
