#pragma once
#include <memory>
#include <iostream>

#include "Command.h"
#include "Element.h"

#include "Gear.h"
#include "Direction.h"
#include "Pause.h"

/**
 * @brief A doubly linked List of std::shared_ptr<Element>
 * 
 */
class CommandList
{
private:
    std::shared_ptr<Element> root = std::make_shared<Element>();
    std::shared_ptr<Element> getElement(unsigned int _pos);

public:
    int getSize();
    void clear();

    int getPos(std::shared_ptr<ICommand> _cmd);
    std::shared_ptr<ICommand> getCommand(unsigned int _pos);

    template <class Type>
    std::shared_ptr<ICommand> add(const Type _cmd);
    std::shared_ptr<ICommand> remove(unsigned int _pos);
    
    std::shared_ptr<ICommand> moveUp(unsigned int _pos);
    std::shared_ptr<ICommand> moveDown(unsigned int _pos);

    std::shared_ptr<ICommand> add(std::shared_ptr<ICommand> _cmd)
    {
    std::shared_ptr<Element> newElement = std::make_shared<Element>(_cmd);
    std::shared_ptr<Element> end = getElement(getSize());
    newElement->setPrev(end);
    end->setNext(newElement);
    return newElement->getCommand();
    }

    void createCommands();
    void printCommands();
};
