#pragma once
#include <string>

#include "commandlib.h"

/**
 * @brief Base class for the specific Command implementations
 *  e.g. Gear, Direction and Pause.
 */
class Command : public virtual ICommand
{
private:
    std::string name;
public:
    /**
     * @brief Construct a new Command object with name _name.
     * 
     * @param _name of the Command
     */
    Command(std::string _name) { name = _name; }

    /**
     * @brief Get the Commands name.
     * 
     * @return std::string name
     */
    std::string getName() { return name; }

    /**
     * @brief Virtual. Implement to return a string version of the Command.
     * 
     * @return std::string representation of the Command.
     */
    virtual std::string getConfig() = 0;
};