#pragma once
#include <QListWidgetItem>

#include "CommandType.h"

/**
 * @brief An Adapter or Proxy between CommandType and the QListWidget.
 *  QListWidget can only display QListWidgetItems, but we need to
 *  remember the according CommandType as well.
 */
class ComTypeListWidgetItem : public QListWidgetItem
{

private:
    CommandType *cT;

public:

    /**
     * @brief Construct a new Com Type List Widget Item object.
     *  Sets the CommandType* and displays it's name with getName().
     * @param _cT 
     */
    ComTypeListWidgetItem(CommandType *_cT)
    {
        cT = _cT;
        if (cT)
            setText(cT->getName().c_str());
    }
    /**
     * @brief Get the Command Type object
     * 
     * @return CommandType* The saved CommandType.
     */
    CommandType *getCommandType() { return cT; }
};
