#pragma once
#include <array>
#include <QLayout>
#include <QTextEdit>
#include <QPushButton>

/**
 * @brief Used to display the About Window.
 *  Use .exec() to display modally.
 */
class AboutDialog : public QDialog
{

private:
    QTextEdit *tA;
    QPushButton *bOk;
    std::array<QString, 7> text{
        "Control Developer",
        "",
        "Tobias Glaser",
        "Software intensive Systems SS22",
        "Reutlingen University",
        "",
        "https://github.com/tobiglaser/java2cpp"};

public:
    /**
     * @brief Construct a new About Dialog object
     *  Sets View and connects the button to the accept slot,
     *  closing the window.
     */
    AboutDialog()
    {
        setWindowTitle("About");
        QVBoxLayout *l = new QVBoxLayout();
        this->setLayout(l);
        tA = new QTextEdit();
        tA->setReadOnly(true);
        tA->setAlignment(Qt::AlignCenter);
        for (auto &&i : text)
        {
            tA->append(i);
        }
        l->addWidget(tA);
        bOk = new QPushButton("Ok");
        l->addWidget(bOk);
        updateGeometry();
        connect(bOk, SIGNAL(clicked()), this, SLOT(accept()));
    };
};