// hsrt.mec.controldeveloper.core.com.command
#pragma once
#include <string>

class ICommand
{
public:
    virtual std::string getName() = 0;
};

class IDirection : public virtual ICommand
{
public:
    inline static const std::string direction = "Direction";

    virtual int getDegree() = 0;
};

class IGear : public virtual ICommand
{
public:
    inline static const std::string gear = "Gear";

    virtual int getSpeed() = 0;
    virtual double getDuration() = 0;
};

class IPause : public virtual ICommand
{
public:
    inline static const std::string pause = "Pause";

    virtual double getDuration() = 0;
};