#pragma once
#include <fstream>
#include <sstream>
#include <vector>
#include <memory>
#include "commandlib.h"
#include "../src/Gear.h"
#include "../src/Direction.h"
#include "../src/Pause.h"

/**
 * @brief The ObjectFileHandler is used by ControlModel to read and write
 *  ICommands to and from a file.
 */
class ObjectFileHandler
{
private:
    std::string fileName;

public:
    ObjectFileHandler(std::string _file);
    std::string getFileName() { return fileName; }
    bool read(std::vector <std::shared_ptr<ICommand>> &destination);
    bool write(const std::vector<std::shared_ptr<ICommand>> &source);
};
