#pragma once
#include "IComListener.h"
#include "ComState.h"
#include "BackgroundControl.h"
#include "commandlib.h"
#include "Rover.h"
#include <memory>
#include <vector>

/**
 * @brief Uses magic to communicate to the Rover.
 *  Implemented as Singleton using getInstance().
 */
class ComHandler
{
private:
    std::optional<IComListener *> comListener;
    BackgroundControl backgroundControl;
    ComHandler() {}

public:
    static ComHandler &getInstance();
    void registerComListener(IComListener *cl);
    void unregisterComListener(IComListener *cl);
    bool start(std::vector<std::shared_ptr<ICommand>> commands, std::optional<Rover> rover);
    /**
     * @brief Will stop the execution, currently does nothing.
     * @return always true 
     */
    bool stop() { return true; }
};
