#pragma once
#include "commandlib.h"
#include "Command.h"
#include <string>

class Pause : public Command, public IPause
{
private:
    double duration;
public:
    Pause();
    Pause(double newDuration);
    void setDuration(double newDuration);
    double getDuration() { return duration; }
    std::string getConfig();
};

Pause::Pause(double newDuration) : Command(IPause::pause)
{
    setDuration(newDuration);
}

void Pause::setDuration(double newDuration)
{
    if (newDuration < 0)
        duration = 0;
    else
        duration = newDuration;
}

std::string Pause::getConfig()
{
    std::string str = IPause::pause
                    + " - Duration: "
                    + std::to_string(duration);
    return str;
};