#pragma once
#include "commandlib.h"
#include "Command.h"
#include <string>

class Gear : public Command, public IGear
{
private:
    int speed;
    double duration;

public:
    Gear();
    Gear(int newSpeed, double newDuration);
    void setSpeed(int newSpeed);
    int getSpeed() { return speed; }
    void setDuration(double newDuration);
    double getDuration() { return duration; }
    std::string getConfig();
};

Gear::Gear(int newSpeed, double newDuration) : Command(IGear::gear)
{
    setSpeed(newSpeed);
    setDuration(newDuration);
}

void Gear::setSpeed(int newSpeed)
{
    if (newSpeed <= -100)
        speed = -100;
    else if (newSpeed >= 100)
        speed = 100;
    else
        speed = newSpeed;
}

void Gear::setDuration(double newDuration)
{
    if (newDuration < 0)
        duration = 0;
    else
        duration = newDuration;
}

std::string Gear::getConfig()
{
    std::string str = IGear::gear
                    + " - Speed: "
                    + std::to_string(speed)
                    + " for: "
                    + std::to_string(duration)
                    + 's';
    return str;
}