#pragma once
#include "commandlib.h"
#include "Command.h"
#include <string>

class Direction : public Command, public IDirection
{
private:
    int degree;
public:
    Direction();
    Direction(int newDegree);
    void setDegree(int newDegree);
    int getDegree() { return degree; }
    std::string getConfig();
};

Direction::Direction(int newDegree) : Command(IDirection::direction)
{
    setDegree(newDegree);
}

void Direction::setDegree(int newDegree)
{
    if (newDegree <= -90)
        degree = -90;
    else if (newDegree >= 90)
        degree = 90;
    else
        degree = newDegree;
}

std::string Direction::getConfig()
{
    std::string str = IDirection::direction
                    + " - Degree: "
                    + std::to_string(degree)
                    + '.';
    return str;
};