#pragma once
#include <memory>
#include <iostream>

#include "Command.h"
#include "Element.h"

#include "Gear.h"
#include "Direction.h"
#include "Pause.h"


class CommandList
{
private:
    std::shared_ptr<Element> root = std::make_shared<Element>();
    std::shared_ptr<Element> getElement(unsigned int _pos);

public:
    int getSize();
    void clear();

    int getPos(std::shared_ptr<Command> _cmd);
    std::shared_ptr<Command> getCommand(unsigned int _pos);

    template <class Type>
    std::shared_ptr<Command> add(const Type _cmd);
    std::shared_ptr<Command> remove(unsigned int _pos);
    
    std::shared_ptr<Command> moveUp(unsigned int _pos);
    std::shared_ptr<Command> moveDown(unsigned int _pos);

    void createCommands();
    void printCommands();
};

int CommandList::getSize()
{
    std::shared_ptr<Element> ptr = root;
    int i = 0;
    for (; ptr->getNext(); ++i)
    {
        ptr = ptr->getNext();
    }
    return i;
}

void CommandList::clear()
{
    std::shared_ptr<Element> current = root;
    std::shared_ptr<Element> next = current->getNext();

    while (next)
    {
        current->setPrev(nullptr);
        current->setNext(nullptr);
        current = next;
        next = next->getNext();
    }
}

template <class Type>
std::shared_ptr<Command> CommandList::add(const Type _cmd)
{
    std::shared_ptr<Element> newElement = std::make_shared<Element>(_cmd);
    std::shared_ptr<Element> end = getElement(getSize());
    newElement->setPrev(end);
    end->setNext(newElement);
    return newElement->getCommand();
}

//clears list before adding 5 Commands
void CommandList::createCommands()
{
    clear();

    add(Gear(10, 2.71));
    add(Direction(90));
    add(Pause(2.5));
    add(Direction(-90));
    add(Gear(-10, 2.71));
}

void CommandList::printCommands()
{
    std::shared_ptr<Element> current = root;
    while (current->getNext())
    {
        //In this order to not print out the root element.
        current = current->getNext();
        std::cout << current->getCommand()->getConfig() << '\n';
    }
}

std::shared_ptr<Command> CommandList::remove(unsigned int _pos)
{
    std::shared_ptr<Element> toRemove = getElement(_pos);
    if (toRemove == nullptr | toRemove == root)
    {
        return nullptr;
    }
    std::cout << "removing: " << toRemove->getCommand()->getName() << '\n';
    std::shared_ptr<Element> prev = toRemove->getPrev();
    std::shared_ptr<Element> next = toRemove->getNext();
    prev->setNext(next);
    if (next)
        next->setPrev(prev);

    return toRemove->getCommand();
}

std::shared_ptr<Element> CommandList::getElement(unsigned int _pos)
{
    if (_pos > getSize())
    {
        return nullptr;
    }
    std::shared_ptr<Element> elem = root;
    for (int i = 0; elem->getNext() && i < _pos; ++i)
    {
        elem = elem->getNext();
    }
    return elem;
}

std::shared_ptr<Command> CommandList::getCommand(unsigned int _pos)
{
    std::shared_ptr<Element> elem = getElement(_pos);
    if (elem == nullptr)
    {
        return nullptr;
    }
    else
    {
        return elem->getCommand();
    }
}

int CommandList::getPos(std::shared_ptr<Command> _cmd)
{
    std::shared_ptr<Element> elem = root;
    int i = 0;
    int size = getSize();
    while (elem->getNext() && elem->getCommand() != _cmd)
    {
        elem = elem->getNext();
        ++i;
        if (i > size)
        {
            return -1;
        }
    }
    return i;
}

std::shared_ptr<Command> CommandList::moveUp(unsigned int _pos)
{
    if (_pos <= 1)
    {
        return nullptr;
    }
    std::shared_ptr<Element> ptr = getElement(_pos);
    std::shared_ptr<Element> prevPtr = getElement(_pos -1);
    if (ptr == nullptr | prevPtr == nullptr)
    {
        return nullptr;
    }
    std::shared_ptr<Command> toReturn = ptr->getCommand();

    prevPtr->getPrev()->setNext(ptr);
    ptr->setPrev(prevPtr->getPrev());

    ptr->getNext()->setPrev(prevPtr);
    prevPtr->setNext(ptr->getNext());

    prevPtr->setPrev(ptr);
    ptr->setNext(prevPtr);

    return toReturn;
}

std::shared_ptr<Command> CommandList::moveDown(unsigned int _pos)
{
    std::shared_ptr<Element> ptr = getElement(_pos);
    std::shared_ptr<Element> nextPtr = getElement(_pos +1);
    if (ptr == nullptr | nextPtr == nullptr | ptr == root)
    {
        return nullptr;
    }
    std::shared_ptr<Command> toReturn = ptr->getCommand();

    ptr->getPrev()->setNext(nextPtr);
    nextPtr->setPrev(ptr->getPrev());

    nextPtr->getNext()->setPrev(ptr);
    ptr->setNext(nextPtr->getNext());

    ptr->setPrev(nextPtr);
    nextPtr->setNext(ptr);

    return toReturn;
}