#include <iostream>
#include "CommandListOWN.h"


int main(int argc, char const *argv[])
{
    using namespace std;
    CommandList list;
    cout << list.getSize() << '\n';
    list.printCommands();
    list.add(Command("First"));
    cout << list.getSize() << '\n';
    list.printCommands();
    list.add(Command("Second"));
    cout << list.getSize() << '\n';
    list.printCommands();
    list.add(Command("Third"));
    cout << list.getSize() << '\n';
    list.printCommands();
    list.add(Command("Fourth"));
    cout << list.getSize() << '\n';
    list.printCommands();
    list.add(Command("Fifth"));
    cout << list.getSize() << '\n';
    list.printCommands();

    cout << "removing 4th\n";
    std::shared_ptr<Command> cmdPtr = list.remove(4);
    if (!cmdPtr)
    {
        cout << "It's NULL\n";
    }
    else
    {
        cout << cmdPtr->getName() << '\n';
    }

    cout << "getting 3rd\n";
    cmdPtr = list.getCommand(3);
    cout << cmdPtr->getName() << '\n';
    cout << "getting 6th*\n";
    cmdPtr = list.getCommand(6);
    if (!cmdPtr)
    {
        cout << "It's NULL\n";
    }
    else
    {
        cout << cmdPtr->getName() << '\n';
    }

    cmdPtr = list.getCommand(2);
    int two = list.getPos(cmdPtr);
    if (two == 2)
    {
        cout << "getPos works\n";
    }

    cout << "List original:\n";
    list.printCommands();
    cout << "moved up 3:\n";
    list.moveUp(3);
    list.printCommands();
    cout << "moved down 2:\n";
    list.moveDown(2);
    list.printCommands();

    cout << "clearing\n";
    list.clear();

    cout << "End of Scope\n";
    return 0;
}
