#pragma once
#include <memory>

#include "Command.h"

class Element
{
private:
    std::shared_ptr<Element> next;
    std::shared_ptr<Element> prev;
    std::shared_ptr<Command> cmd;

public:
    Element(Command _cmd) { cmd = std::make_shared<Command>(_cmd); }
    ~Element() { std::cout << "~Element - " << cmd->getName() << '\n'; }
    std::shared_ptr<Command> getCommand() { return cmd; }
    
    void setNext(std::shared_ptr<Element> _next) { next = _next; }
    std::shared_ptr<Element> getNext() { return next; }

    void setPrev(std::shared_ptr<Element> _prev) { prev = _prev; }
    std::shared_ptr<Element> getPrev() { return prev; }
};