#pragma once
#include <memory>
#include <iostream>

#include "Command.h"
#include "Element.h"



class CommandList
{
private:
    std::shared_ptr<Element> root = std::make_shared<Element>(Command("root"));
    std::shared_ptr<Element> getElement(uint _pos);

public:
    int getSize();
    void clear();

    int getPos(std::shared_ptr<Command> _cmd);
    std::shared_ptr<Command> getCommand(uint _pos);

    Command add(Command _cmd);
    std::shared_ptr<Command> remove(uint _pos);
    
    std::shared_ptr<Command> moveUp(uint _pos);
    std::shared_ptr<Command> moveDown(uint _pos);

    void printCommands();
};

int CommandList::getSize()
{
    std::shared_ptr<Element> ptr = root;
    int i = 0;
    for (; ptr->getNext(); ++i)
    {
        ptr = ptr->getNext();
    }
    return i;
}

void CommandList::clear()
{
    std::shared_ptr<Element> current = root;
    std::shared_ptr<Element> next = current->getNext();

    while (next)
    {
        current->setPrev(NULL);
        current->setNext(NULL);
        current = next;
        next = next->getNext();
    }
}

Command CommandList::add(Command _cmd)
{
    std::shared_ptr<Element> newElement = std::make_shared<Element>(_cmd);
    std::shared_ptr<Element> end = getElement(getSize());
    newElement->setPrev(end);
    end->setNext(newElement);
    return _cmd;
}

void CommandList::printCommands()
{
    std::shared_ptr<Element> current = root;
    while (current->getNext())
    {
        //In this order to not print out the root element.
        current = current->getNext();
        std::cout << current->getCommand()->getName() << '\n';
    }
}

std::shared_ptr<Command> CommandList::remove(uint _pos)
{
    std::shared_ptr<Element> toRemove = getElement(_pos);
    if (toRemove == NULL | toRemove == root)
    {
        return NULL;
    }
    std::cout << "removing: " << toRemove->getCommand()->getName() << '\n';
    std::shared_ptr<Element> prev = toRemove->getPrev();
    std::shared_ptr<Element> next = toRemove->getNext();
    prev->setNext(next);
    if (next)
        next->setPrev(prev);

    return toRemove->getCommand();
}

std::shared_ptr<Element> CommandList::getElement(uint _pos)
{
    if (_pos > getSize())
    {
        return NULL;
    }
    std::shared_ptr<Element> elem = root;
    for (int i = 0; elem->getNext() && i < _pos; ++i)
    {
        elem = elem->getNext();
    }
    return elem;
}

std::shared_ptr<Command> CommandList::getCommand(uint _pos)
{
    std::shared_ptr<Element> elem = getElement(_pos);
    if (elem == NULL)
    {
        return NULL;
    }
    else
    {
        return elem->getCommand();
    }
}

int CommandList::getPos(std::shared_ptr<Command> _cmd)
{
    std::shared_ptr<Element> elem = root;
    int i = 0;
    int size = getSize();
    while (elem->getNext() && elem->getCommand() != _cmd)
    {
        elem = elem->getNext();
        ++i;
        if (i > size)
        {
            return -1;
        }
    }
    return i;
}

std::shared_ptr<Command> CommandList::moveUp(uint _pos)
{
    if (_pos <= 1)
    {
        return NULL;
    }
    std::shared_ptr<Element> ptr = getElement(_pos);
    std::shared_ptr<Element> prevPtr = getElement(_pos -1);
    if (ptr == NULL | prevPtr == NULL)
    {
        return NULL;
    }
    std::shared_ptr<Command> toReturn = ptr->getCommand();

    prevPtr->getPrev()->setNext(ptr);
    ptr->setPrev(prevPtr->getPrev());

    ptr->getNext()->setPrev(prevPtr);
    prevPtr->setNext(ptr->getNext());

    prevPtr->setPrev(ptr);
    ptr->setNext(prevPtr);

    return toReturn;
}

std::shared_ptr<Command> CommandList::moveDown(uint _pos)
{
    std::shared_ptr<Element> ptr = getElement(_pos);
    std::shared_ptr<Element> nextPtr = getElement(_pos +1);
    if (ptr == NULL | nextPtr == NULL | ptr == root)
    {
        return NULL;
    }
    std::shared_ptr<Command> toReturn = ptr->getCommand();

    ptr->getPrev()->setNext(nextPtr);
    nextPtr->setPrev(ptr->getPrev());

    nextPtr->getNext()->setPrev(ptr);
    ptr->setNext(nextPtr->getNext());

    ptr->setPrev(nextPtr);
    nextPtr->setNext(ptr);

    return toReturn;
}